@extends('layouts.app')

@section('content')
    <!-- Page Header -->
    <div class="py-8 sm:py-12 md:py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-4">Hasil Pemeriksaan Rekanan</h1>
                <p class="text-lg sm:text-xl text-gray-600">Akses hasil pemeriksaan rekanan dengan mudah dan aman</p>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 sm:py-12 md:py-16 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-lg sm:rounded-none">
                <div class="p-8 text-gray-900">
                    @if (!isset($partner))
                        <!-- Form Login -->
                        <div class="max-w-md mx-auto">
                            <div class="text-center mb-8">
                                <div
                                    class="w-16 h-16 bg-[#192D50] rounded-full flex items-center justify-center mx-auto mb-4">
                                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                        </path>
                                    </svg>
                                </div>
                                <h3 class="text-xl sm:text-2xl font-bold text-gray-900 mb-2">Hasil Pemeriksaan Rekanan</h3>
                                <p class="text-gray-600">Masukkan kode rekanan dan password Anda</p>
                            </div>

                            <form method="POST" action="{{ route('results.partner.check') }}" class="space-y-6">
                                @csrf

                                <div>
                                    <label for="code" class="block text-sm font-medium text-gray-700 mb-2">Kode
                                        Rekanan</label>
                                    <input type="text" id="code" name="code" value="{{ old('code') }}" required
                                        autofocus
                                        class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('code')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="password"
                                        class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                                    <input type="password" id="password" name="password" required
                                        class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('password')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="flex items-center justify-end">
                                    <button type="submit"
                                        class="bg-[#192D50] text-white px-6 py-3 rounded-none font-semibold hover:bg-[#192D50] transition duration-150">
                                        Cari
                                    </button>
                                </div>
                            </form>
                        </div>
                    @else
                        <!-- Hasil Pemeriksaan Rekanan -->
                        <div class="mb-8">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-[#192D50] rounded-full flex items-center justify-center mr-4">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                        </path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-xl sm:text-2xl font-bold text-gray-900">Selamat datang, {{ $partner->name }}!</h3>
                                    <p class="text-gray-600">Berikut adalah hasil pemeriksaan yang terhubung dengan rekanan
                                        Anda:</p>
                                </div>
                            </div>
                        </div>

                        @if ($examResults->count() > 0)
                            <div class="space-y-6">
                                @foreach ($examResults as $result)
                                    <div
                                        class="bg-gray-50 border border-gray-200 p-6 rounded-none hover:shadow-md transition duration-150">
                                        <div class="flex justify-between items-start mb-4">
                                            <div class="flex-1">
                                                <h4 class="text-lg font-semibold text-gray-900 mb-2">
                                                    {{ ucfirst($result->exam_type) }}</h4>
                                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-600">
                                                    @if($result->patient)
                                                        <div>
                                                            <span class="font-medium">Pasien:</span>
                                                            {{ $result->patient->name }}
                                                        </div>
                                                        <div>
                                                            <span class="font-medium">MRN:</span> {{ $result->patient->mrn ?? 'Belum ada' }}
                                                        </div>
                                                        <div>
                                                            <span class="font-medium">Email:</span>
                                                            {{ $result->patient->email }}
                                                        </div>
                                                    @elseif($result->employee)
                                                        <div>
                                                            <span class="font-medium">Karyawan:</span>
                                                            {{ $result->employee->name }}
                                                        </div>
                                                        <div>
                                                            <span class="font-medium">Perusahaan:</span>
                                                            {{ $result->employee->company->name ?? 'N/A' }}
                                                        </div>
                                                        <div>
                                                            <span class="font-medium">Nomor Karyawan:</span>
                                                            {{ $result->employee->employee_number }}
                                                        </div>
                                                    @elseif($result->partner)
                                                        <div>
                                                            <span class="font-medium">Rekanan:</span>
                                                            {{ $result->partner->name }}
                                                        </div>
                                                        <div>
                                                            <span class="font-medium">Kode:</span>
                                                            {{ $result->partner->code }}
                                                        </div>
                                                    @else
                                                        <div>
                                                            <span class="font-medium">Subjek:</span>
                                                            Tidak Diketahui
                                                        </div>
                                                    @endif
                                                    <div>
                                                        <span class="font-medium">Tanggal:</span>
                                                        {{ $result->exam_date->format('d F Y') }}
                                                    </div>
                                                </div>
                                                @if ($result->notes)
                                                    <p class="text-sm text-gray-600 mt-2">{{ $result->notes }}</p>
                                                @endif
                                            </div>
                                            <div class="flex items-center space-x-3">
                                                <span
                                                    class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                                                    @if ($result->status == 'completed') bg-green-100 text-green-800
                                                    @elseif($result->status == 'pending') bg-yellow-100 text-yellow-800
                                                    @else bg-red-100 text-red-800 @endif">
                                                    {{ ucfirst($result->status) }}
                                                </span>
                                            </div>
                                        </div>

                                        <!-- File Section -->
                                        @if ($result->result_file_path)
                                            <div class="bg-white border border-gray-200 rounded-none p-4">
                                                <div class="flex items-center justify-between">
                                                    <div class="flex items-center">
                                                        <div
                                                            class="w-10 h-10 bg-[#192D50] rounded-none flex items-center justify-center mr-3">
                                                            <svg class="w-5 h-5 text-white" fill="none"
                                                                stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                                </path>
                                                            </svg>
                                                        </div>
                                                        <div>
                                                            <p class="text-sm font-medium text-gray-900">File Hasil
                                                                Pemeriksaan</p>
                                                            <p class="text-xs text-gray-500">
                                                                {{ basename($result->result_file_path) }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="flex items-center space-x-2">
                                                        <a href="{{ route('results.file.view', $result->id) }}"
                                                            target="_blank"
                                                            class="inline-flex items-center px-3 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#192D50]">
                                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor"
                                                                viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z">
                                                                </path>
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                                                </path>
                                                            </svg>
                                                            Lihat
                                                        </a>
                                                        <a href="{{ route('results.file.download', $result->id) }}"
                                                            class="inline-flex items-center px-3 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#192D50]">
                                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor"
                                                                viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                                </path>
                                                            </svg>
                                                            Download
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        @else
                                            <div class="bg-[#192D50] border border-white rounded-none p-4">
                                                <div class="flex items-center">
                                                    <div class="w-5 h-5 text-[#CBB4B0] mr-2">
                                                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2"
                                                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z">
                                                            </path>
                                                        </svg>
                                                    </div>
                                                    <p class="text-sm text-[#CBB4B0]">File hasil pemeriksaan belum
                                                        tersedia</p>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-12">
                                <div
                                    class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-gray-100 mb-4">
                                    <svg class="h-8 w-8 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                        </path>
                                    </svg>
                                </div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">Belum Ada Hasil</h3>
                                <p class="text-gray-600 mb-6">
                                    Belum ada hasil pemeriksaan yang terhubung dengan rekanan Anda.
                                    Silakan cek kembali nanti atau hubungi klinik.
                                </p>
                            </div>
                        @endif
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
